<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Google\Site_Kit_Dependencies\Google\Service\SubscribewithGoogle;

class Order extends \Google\Site_Kit_Dependencies\Google\Collection
{
    protected $collection_key = 'stateDetails';
    /**
     * @var string
     */
    public $name;
    /**
     * @var string
     */
    public $orderId;
    protected $stateDetailsType = \Google\Site_Kit_Dependencies\Google\Service\SubscribewithGoogle\StateDetails::class;
    protected $stateDetailsDataType = 'array';
    /**
     * @param string
     */
    public function setName($name)
    {
        $this->name = $name;
    }
    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * @param string
     */
    public function setOrderId($orderId)
    {
        $this->orderId = $orderId;
    }
    /**
     * @return string
     */
    public function getOrderId()
    {
        return $this->orderId;
    }
    /**
     * @param StateDetails[]
     */
    public function setStateDetails($stateDetails)
    {
        $this->stateDetails = $stateDetails;
    }
    /**
     * @return StateDetails[]
     */
    public function getStateDetails()
    {
        return $this->stateDetails;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(\Google\Site_Kit_Dependencies\Google\Service\SubscribewithGoogle\Order::class, 'Google\\Site_Kit_Dependencies\\Google_Service_SubscribewithGoogle_Order');
