<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// BEGIN ENQUEUE PARENT ACTION
// AUTO GENERATED - Do not modify or remove comment markers above or below:

if ( !function_exists( 'chld_thm_cfg_locale_css' ) ):
    function chld_thm_cfg_locale_css( $uri ){
        if ( empty( $uri ) && is_rtl() && file_exists( get_template_directory() . '/rtl.css' ) )
            $uri = get_template_directory_uri() . '/rtl.css';
        return $uri;
    }
endif;
add_filter( 'locale_stylesheet_uri', 'chld_thm_cfg_locale_css' );
         
if ( !function_exists( 'child_theme_configurator_css' ) ):
    function child_theme_configurator_css() {
        wp_enqueue_style( 'chld_thm_cfg_child', trailingslashit( get_stylesheet_directory_uri() ) . 'style.css', array( 'astra-theme-css' ) );
    }
endif;
add_action( 'wp_enqueue_scripts', 'child_theme_configurator_css', 10 );

/* ajouter champ "Extrait" dans les page WP */
function ajouter_extrait_pages() {
	add_post_type_support( 'page', 'excerpt' );
}
add_action( 'init', 'ajouter_extrait_pages' );

// ---------------------------------------------------------------------------------------------------------------------
//   Groovy Menu plugin integration. With Astra 2.5+ version support.
// ---------------------------------------------------------------------------------------------------------------------
if ( ! function_exists( 'gm_astra_child_init_function' ) ) {
	function gm_astra_child_init_function() {
		if ( function_exists( 'groovy_menu' ) ) {

			// We remove the function that rewrites all CSS classes from the Groovy Menu plugin.
			remove_filter( 'nav_menu_link_attributes', 'astra_menu_anchor_class_for_nav_menus' );

			// Remove default header.
			remove_action( 'astra_header', 'astra_header_markup' );

			// Add Groovy Menu for the header.
			add_action( 'astra_header_before', 'gm_astra_child_add_groovy_menu', 5 );
		}
	}
}

if ( ! function_exists( 'gm_astra_child_add_groovy_menu' ) ) {
	function gm_astra_child_add_groovy_menu() {
		if ( function_exists( 'groovy_menu' ) ) {

			groovy_menu();

		}
	}
}


// Main init hook for Groovy Menu integration with Astra.
add_action( 'init', 'gm_astra_child_init_function', 1000 );

// END ENQUEUE PARENT ACTION
